function [TRF_name , TRF_acc] = FindSpeciesOfTRFsize(sizeOf_TRF, ARB_branch)
%
%
%
switch length(sizeOf_TRF)

    case 0  % the length of the TRF was not specified

    
    TRF_name = []; TRF_acc = [];
    return
    
    case 1  % search for TRF of one length
 
    
    IDX = find(ARB_branch.fullDigest_forward_iTRF == sizeOf_TRF);

    for iIDX = 1 : length(IDX)

        % species full_name
        TRF_name(iIDX,1:length(ARB_branch.species(IDX(iIDX)).Children(3).Data)) = ARB_branch.species(IDX(iIDX)).Children(3).Data;

        % species acc
        TRF_acc(iIDX,1:length(ARB_branch.species(IDX(iIDX)).Children(1).Data)) = ARB_branch.species(IDX(iIDX)).Children(1).Data;

    end
    
    otherwise
        % under construction
end